<?php

class InformationController extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    public function __construct()
    {
        parent::__construct();
        if (!Csrf::isTokenValid()) {
          //redirect to forbidden and exit
          header('HTTP/1.0 403 Forbidden', true, 403);
          exit();
        }

        $this->user=Auth::isAuthenticated();
    }

    /**
     * Handles what happens when user moves to URL/index/index - or - as this is the default controller, also
     * when user moves to /index or enter your application at base level
     */
    public function index()
    {
        $username=$this->user->{'cognito:username'};
        $role=RoleModel::getUserRole($username);
        $roleid=RoleModel::getRoleAsId($role['role']);
        $vehicles=RoleModel::mapVehicles($role['vehicles']);
        /*set the initial vehicleid*/
        Session::set('vehicleid',$role['vehicles'][0]);
        $files=array('index/index','information/index');

        $this->View->renderMultiSpecial($files, array(
           'username' => $username,
           'role' => $role,
           'vehicles' => $vehicles,
           'permissions' => RoleModel::getPermissionsForRole($role),
           'notifications' => InformationModel::getNotifications($roleid->id,$role['vehicles'])
        ),'header');
    }

}